#ifdef RCSID
static char *RCSid =
   "$Header: occidemo0.cc 08-mar-2001.17:09:47 mkrohan Exp $;
#endif /* RCSID */

/* Copyright (c) Oracle Corporation 2001. All Rights Reserved. */

/*

   NAME
     occidemo0.cpp - OCCI Bind Var demo

   DESCRIPTION
     Shows how bind variables can be set using both the setXXX interface and the
     setDataBuffer interface.


   PUBLIC FUNCTION(S)

   PRIVATE FUNCTION(S)

   RETURNS

   NOTES


   MODIFIED   (MM/DD/YY)
   mkrohan   03/08/01 - Merged mkrohan_occidemo_mk
   slari     02/15/01 - Creation

*/

#ifndef OCCI_ORACLE
#include <occi.h>
#endif // !OCCI_ORACLE

#include <string.h>


int main(int argc, char *argv[])
{
  OCCIEnvironment *env;
    
  try
  {
    int	id = 420;
    char ename[] = "SMITH";
    ub2 len = strlen(ename) + 1;
    
    env = OCCIEnvironment::createEnvironment(OCCIEnvironment::DEFAULT);
    
    OCCIConnection *conn = env->createConnection("scott", "tiger");
    
    OCCIStatement *stmt = conn->createStatement(
   "update emp set empno = :1 where ename = :2");

    stmt->setInt(1, id);
    stmt->setDataBuffer(2, ename, OCCI_SQLT_STR, sizeof(ename), &len);
    stmt->execute();
    
    stmt->setSQL("update emp set ename = :1 where empno = :2");
    stmt->setString(1, "DOE");
    stmt->setInt(2, id);
    stmt->execute();

    OCCIResultSet *resultSet = stmt->executeQuery("select empno, ename from emp");

    cout << "Result Set status = " << resultSet->status() << endl;

    while (resultSet->next())
    {
      cout << "empno = " << resultSet->getInt(1) <<
        " ename = " << resultSet->getString(2) << endl;
    }
    
    stmt->closeResultSet(resultSet);
    
    conn->terminateStatement(stmt);

    conn->rollback();
    
    env->terminateConnection(conn);
    
    OCCIEnvironment::terminateEnvironment(env);
  }

  catch (OCCISQLException ex)
  {
    int errorCode = ex.getErrorCode();
    
    string message = ex.getMessage();
    
    cout << "Error = " << errorCode << " -- " << message.data() << endl;

    OCCIEnvironment::terminateEnvironment(env);

    cout << "End occidemoBVar test" << endl;
  }

  catch (...)
  {
    cout << "Uncaught Exception!" << endl;
  }
}

/* end of file occidemoBVar.cpp */
